<?php
session_start();
include 'koneksi.php';

$login_error = "";

// Proses login
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['password'])) {
            $_SESSION['username'] = $row['username'];
            header("Location: index.php");
            exit();
        } else {
            $login_error = "Password salah.";
        }
    } else {
        $login_error = "Username tidak ditemukan.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Sistem Perkuliahan - Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">

<div class="w-full max-w-md bg-white p-6 rounded-lg shadow-md">
    <div class="mb-6 text-center">
        <h1 class="text-3xl font-bold text-blue-700">Sistem Perkuliahan</h1>
        <p class="text-sm text-gray-600 mt-1">Silakan login untuk masuk ke sistem</p>
    </div>

    <!-- Login Form -->
    <form id="login-form" method="POST" class="space-y-4">
        <input type="hidden" name="login" value="1">
        <?php if ($login_error): ?>
            <div class="bg-red-100 text-red-700 px-4 py-2 rounded text-sm"><?= $login_error ?></div>
        <?php endif; ?>

        <div>
            <label class="block text-sm font-medium text-gray-700">Username</label>
            <input type="text" name="username" required
                   class="w-full border border-gray-300 rounded px-3 py-2 mt-1 focus:ring-blue-500 focus:border-blue-500">
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700">Password</label>
            <input type="password" name="password" required
                   class="w-full border border-gray-300 rounded px-3 py-2 mt-1 focus:ring-blue-500 focus:border-blue-500">
        </div>
        <button type="submit"
                class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded">Login</button>
    </form>
</div>

</body>
</html>
