<?php
include 'session_check.php';
include 'db.php';

$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $stmt = $koneksi->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
    $stmt->bind_param("ss", $username, $password);

    if ($stmt->execute()) {
        $message = "✅ User berhasil ditambahkan.";
    } else {
        $message = "❌ Gagal menambahkan user.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Tambah User</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="flex">
  <!-- Sidebar -->
  <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
    <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
    <nav class="space-y-1">
      <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
      <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
      <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
      <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
      <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
      <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
      <hr class="my-3 border-gray-700">
      <a href="users.php" class="block py-2 px-4 bg-blue-700 rounded hover:bg-blue-800">👥 Manajemen User</a>
      <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
    </nav>
  </div>

  <!-- Main Content -->
  <div class="flex-1 p-8">
    <h2 class="text-3xl font-semibold mb-6">➕ Tambah User</h2>

    <?php if ($message): ?>
      <div class="mb-4 p-4 rounded text-sm <?= strpos($message, '✅') !== false ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
        <?= $message ?>
      </div>
    <?php endif; ?>

    <form method="POST" class="bg-white p-6 rounded shadow max-w-md space-y-4">
      <div>
        <label class="block text-sm font-medium text-gray-700">Username</label>
        <input type="text" name="username" required class="w-full border px-3 py-2 rounded focus:outline-none focus:ring">
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-700">Password</label>
        <input type="password" name="password" required class="w-full border px-3 py-2 rounded focus:outline-none focus:ring">
      </div>
      <div class="flex justify-between">
        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">Simpan</button>
        <a href="users.php" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">← Kembali</a>
      </div>
    </form>
  </div>
</div>

</body>
</html>
